document.addEventListener("DOMContentLoaded", () => {
  // Obsługa klików na kółka kategorii
  document.querySelectorAll(".category-circle").forEach((circle) => {
    circle.addEventListener("click", () => {
      // Dezaktywuj wszystkie
      document.querySelectorAll(".category-circle").forEach((c) =>
        c.classList.remove("active")
      );
      document.querySelectorAll(".tab-content").forEach((tab) =>
        tab.classList.remove("active")
      );

      // Aktywuj kliknięte
      circle.classList.add("active");
      const target = circle.getAttribute("data-tab");
      const targetContent = document.getElementById(target);
      if (targetContent) {
        targetContent.classList.add("active");
      }
    });
  });

  // Domyślnie aktywne bezpieczeństwo
  const firstCircle = document.querySelector('.category-circle[data-tab="security"]');
  const firstContent = document.getElementById("security");
  if (firstCircle && firstContent) {
    firstCircle.classList.add("active");
    firstContent.classList.add("active");
  }

  // Rozwijanie/zamykanie szczegółów
  document.addEventListener("click", (e) => {
    if (e.target.classList.contains("toggle-details")) {
      const parent = e.target.closest(".check-item");
      if (!parent) return;
      const details = parent.querySelector(".details");
      if (!details) return;

      const isVisible = details.style.display === "block";
      details.style.display = isVisible ? "none" : "block";
      e.target.textContent = isVisible ? "+ Szczegóły" : "− Ukryj";
    }
  });

  // Animacja liczników w kółkach
  const animateCounters = () => {
    const counters = document.querySelectorAll('.circle-number');
    
    counters.forEach(counter => {
      const target = parseInt(counter.textContent);
      if (isNaN(target)) return;
      
      let current = 0;
      const increment = target / 60; // Zwiększone z 30 na 60 kroków
      
      const timer = setInterval(() => {
        current += increment;
        if (current >= target) {
          current = target;
          clearInterval(timer);
        }
        counter.textContent = Math.round(current) + '%';
      }, 80); // Zwiększone z 50ms na 80ms
    });

    // Animacja głównego wyniku
    const mainScore = document.querySelector('.score-content .percent');
    if (mainScore) {
      const target = parseInt(mainScore.textContent.split('/')[0]);
      if (!isNaN(target)) {
        let current = 0;
        const increment = target / 60; // Zwiększone z 30 na 60 kroków
        
        const timer = setInterval(() => {
          current += increment;
          if (current >= target) {
            current = target;
            clearInterval(timer);
          }
          mainScore.textContent = Math.round(current) + '/100';
        }, 80); // Zwiększone z 50ms na 80ms
      }
    }
  };

  // Uruchom animację liczników po załadowaniu - opóźnione żeby zacząć razem z kółkami
  setTimeout(animateCounters, 1200);

  // Hover efekty dla elementów check-item
  document.querySelectorAll('.check-item').forEach(item => {
    item.addEventListener('mouseenter', () => {
      item.style.transform = 'translateY(-2px)';
    });

    item.addEventListener('mouseleave', () => {
      item.style.transform = 'translateY(0)';
    });
  });

  // Smooth scroll do sekcji wyników po kliknięciu kategorii
  document.querySelectorAll('.category-circle').forEach(circle => {
    circle.addEventListener('click', () => {
      const resultsSection = document.querySelector('.wptech-results');
      if (resultsSection) {
        setTimeout(() => {
          resultsSection.scrollIntoView({ 
            behavior: 'smooth', 
            block: 'start' 
          });
        }, 100);
      }
    });
  });

  // Progressive loading animacja dla elementów
  const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
  };

  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.style.opacity = '1';
        entry.target.style.transform = 'translateY(0)';
      }
    });
  }, observerOptions);

  // Obserwuj elementy check-item
  document.querySelectorAll('.check-item').forEach((item, index) => {
    item.style.opacity = '0';
    item.style.transform = 'translateY(20px)';
    item.style.transition = `all 0.5s ease ${index * 0.05}s`;
    observer.observe(item);
  });

  // Obserwuj feature boxy
  document.querySelectorAll('.feature-box').forEach((box, index) => {
    box.style.opacity = '0';
    box.style.transform = 'translateY(30px)';
    box.style.transition = `all 0.6s ease ${index * 0.1}s`;
    observer.observe(box);
  });
});