<?php
/**
 * WP‑TECH: admin-page.php — audyt techniczny
 */

defined('ABSPATH') or die();
require_once plugin_dir_path(__FILE__) . 'class-wptech-audit.php';

function wptech_render_check_item($test) {
    $icon = wptech_get_icon_for_status($test['status']);
    ?>
    <div class="check-item <?php echo esc_attr($test['status']); ?>">
        <div class="check-top">
            <span class="status-icon"><?php echo $icon; ?></span>
            <strong><?php echo wp_kses_post($test['title']); ?></strong>
            <?php if (!empty($test['details'])): ?>
                <span class="toggle-details">+ Szczegóły</span>
            <?php endif; ?>
        </div>
        <?php if (!empty($test['details'])): ?>
            <div class="details">
                <?php
                if (is_array($test['details'])) {
                    echo '<ul>';
                    foreach ($test['details'] as $label => $text) {
                        echo '<li><strong>' . esc_html($label) . ':</strong> ' . wp_kses_post($text) . '</li>';
                    }
                    echo '</ul>';
                } else {
                    echo wp_kses_post($test['details']);
                }
                ?>
            </div>
        <?php endif; ?>
    </div>
    <?php
}
function wptech_get_score_feedback($percent) {
    if ($percent >= 95) {
        return ['color' => '#00a32a', 'text' => 'Świetnie'];
    } elseif ($percent >= 85) {
        return ['color' => '#3cb043', 'text' => 'Dobrze'];
    } elseif ($percent >= 70) {
        return ['color' => '#ffc107', 'text' => 'Do poprawy'];
    } elseif ($percent >= 50) {
        return ['color' => '#ff8c00', 'text' => 'Słabo'];
    } else {
        return ['color' => '#d63638', 'text' => 'Krytycznie'];
    }
}

function wptech_get_icon_for_status($status) {
    switch ($status) {
        case 'ok': return '✅';
        case 'warning': return '⚠️';
        case 'danger': return '❌';
        default: return 'ℹ️';
    }
}

function wptech_render_admin_page() {
    if (isset($_POST['run_wptech_audit']) && check_admin_referer('run_wptech_audit_action')) {
        $results = WPTech_Audit::run_audit();
        update_option('wptech_audit_cached_results', $results);
        update_option('wptech_audit_last_run', current_time('mysql'));
    }

    $results = get_option('wptech_audit_cached_results', []);
    $last_run = get_option('wptech_audit_last_run', null);
    $domain = !empty($_SERVER['HTTP_HOST']) ? sanitize_text_field($_SERVER['HTTP_HOST']) : '';

    $total_tests = 0;
    $ok_tests = 0;

    foreach ($results as $tests) {
        foreach ($tests as $test) {
            $total_tests++;
            if ($test['status'] === 'ok') $ok_tests++;
        }
    }
    $score_percent = $total_tests ? round(($ok_tests / $total_tests) * 100) : 0;
    $feedback_data = wptech_get_score_feedback($score_percent);
    $color = $feedback_data['color'];
    $feedback = $feedback_data['text'];

    $categories = [
        'security' => 'Bezpieczeństwo',
        'performance' => 'Wydajność',
        'compatibility' => 'Aktualność',
        'stability' => 'Stabilność',
    ];
?>

<div class="wptech-logo">
        <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/logo.png'; ?>" alt="Audyt techniczny logo" style="width: 120px; height: auto;">
        <h2>Audyt techniczny <span style="color: #246bff;font-weight: bold;"><?php echo esc_html($domain); ?></span></h2>
</div>


<div class="wptech-wrapper">
    
<?php if (empty($results) || !$last_run): ?>
<div class="wptech-initial-audit">
  <h2 class="wptech-initial-title">
    Rozpocznij swój pierwszy <span>audyt strony WordPress</span>
  </h2>
  <p class="wptech-initial-text">
    Zyskaj pełny obraz kondycji technicznej swojej witryny. Audyt wykona ponad <strong>20 zaawansowanych testów</strong>, aby upewnić się, że Twoja strona działa szybko, bezpiecznie i zgodnie ze standardami.
  </p>

  <div class="wptech-features-grid">
    <div class="feature-box">
      <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/bezpieczenstwo.png'; ?>" alt="Bezpieczeństwo">
      <h3>Bezpieczeństwo</h3>
      <p>Wykrywanie zagrożeń, nieaktualnych wtyczek i błędnych uprawnień plików.</p>
    </div>
    <div class="feature-box">
      <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/wydajnosc.png'; ?>" alt="Wydajność">
      <h3>Wydajność</h3>
      <p>Pomiar TTFB, rozmiaru strony i obecności cache oraz CDN.</p>
    </div>
    <div class="feature-box">
      <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/aktualnosc.png'; ?>" alt="Aktualność">
      <h3>Aktualność</h3>
      <p>Kontrola wersji PHP, WordPress i bazy danych.</p>
    </div>
    <div class="feature-box">
      <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/diagnostyka.png'; ?>" alt="Stabilność">
      <h3>Stabilność</h3>
      <p>Kontrola wersji PHP, WordPress i bazy danych.</p>
    </div>
  </div>

  <div class="wptech-cta-info">
    <p>
      Wykonaj audyt teraz i zyskaj pewność, że Twoja strona jest <strong>gotowa na ruch i odporna na ataki.</strong><br>
      Jeśli potrzebujesz pomocy – ekspert ds. bezpieczeństwa WordPress jest dostępny od ręki.
    </p>
  </div>

  <button type="button" class="wptech-btn-primary wptech-run-audit">
    Uruchom audyt strony
  </button>
  <div class="audit-status" style="margin-top:10px; display:none; color:#555;"></div>
</div>
<?php else: ?>

        
        <div class="wptech-score">

        <div class="score-background-icons">
    <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/bezpieczenstwo.png'; ?>" class="icon icon-lock" alt="">
    <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/wydajnosc.png'; ?>" class="icon icon-speed" alt="">
    <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/aktualnosc.png'; ?>" class="icon icon-update" alt="">
    <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/diagnostyka.png'; ?>" class="icon icon-update" alt="">
  </div>


    <div class="score-circle">
        <svg viewBox="0 0 36 36">
            <defs>
                <linearGradient id="scoreGradient" x1="1" y1="0" x2="0" y2="1">
                    <stop offset="0%" stop-color="#d63638" />
                    <stop offset="100%" stop-color="<?php echo esc_attr($color); ?>" />
                </linearGradient>
            </defs>
            <path class="bg"
                  d="M18 2.0845
                     a 15.9155 15.9155 0 1 1 0 31.831
                     a 15.9155 15.9155 0 1 1 0 -31.831"/>
            <path class="meter"
            style="--circle-percent: <?php echo $score_percent; ?>;"
      stroke="<?php echo esc_attr($color); ?>"
      stroke-dasharray="<?php echo $score_percent; ?>,100"
      d="M18 2.0845
         a 15.9155 15.9155 0 1 1 0 31.831
         a 15.9155 15.9155 0 1 1 0 -31.831"/>
        </svg>


        <?php echo '<style>:root { --wptech-color: ' . esc_attr($color) . '; }</style>'; ?>
        <div class="score-content">
            <div class="percent">
                <?php echo esc_html($score_percent); ?>/100
            </div>
            <div class="feedback">
                <?php echo esc_html($feedback); ?>
            </div>

            <div class="wptech-audit-action">
              <button type="button" class="wptech-btn-secondary wptech-run-audit">
                Uruchom ponownie
              </button>
              <div class="audit-status" style="margin-top:10px; font-size:0.95em; color:#555; display:none;">
                Trwa wykonywanie audytu...
              </div>

              <?php if ($last_run): ?>
                <div class="audit-date">
                  <?php echo esc_html($last_run); ?>
                </div>
              <?php endif; ?>

            </div>
        </div>



    </div>
</div>




        <div class="wptech-categories">
        <?php
        $first = true;
        foreach ($categories as $key => $label):
            $tests = $results[$key] ?? [];
            $count = count($tests);
            $ok = count(array_filter($tests, fn($t) => $t['status'] === 'ok'));
            $percent = $count ? round(($ok / $count) * 100) : 0;

            if ($percent >= 90) {
                $strokeColor = '#0cce6b';
            } elseif ($percent >= 70) {
                $strokeColor = '#ffc107';
            } else {
                $strokeColor = '#d63638';
            }
        ?>
        <div class="category-circle <?php echo $first ? 'active' : ''; ?>" data-tab="<?php echo esc_attr($key); ?>">
        <svg viewBox="0 0 36 36">
        <circle
          cx="18"
          cy="18"
          r="15.9155"
          stroke="#0073aa"
          stroke-width="2"
          fill="none"
        />
        <path
            class="circle-bg"
            d="M18 2.0845
            a 15.9155 15.9155 0 1 1 0 31.831
            a 15.9155 15.9155 0 1 1 0 -31.831"
        />
        <path
            class="circle-meter"
            style="--circle-percent: <?php echo $percent; ?>;"
            stroke="<?php echo esc_attr($strokeColor); ?>"
            stroke-dasharray="<?php echo $percent; ?>,100"
            d="M18 2.0845
            a 15.9155 15.9155 0 1 1 0 31.831
            a 15.9155 15.9155 0 1 1 0 -31.831"
        />
        </svg>
        <div class="circle-number"><?php echo $percent; ?>%</div>
        <div class="circle-label"><?php echo esc_html($label); ?></div>
        </div>
        <?php
        $first = false;
        endforeach;
        ?>
        </div>



    <?php endif; ?>

<?php if (!empty($results) && $last_run): ?>
    <div class="wptech-results">
    <?php
    $first = true;
    foreach ($categories as $key => $label):
        $tests = $results[$key] ?? [];
        echo '<div class="tab-content ' . ($first ? 'active' : '') . '" id="' . esc_attr($key) . '">';
        foreach ($tests as $test) wptech_render_check_item($test);
        echo '</div>';
        $first = false;
    endforeach;
    ?>
    </div>
    

    <!-- Sekcja bezpieczeństwa -->
    <div class="wptech-security-disclaimer">
      <div class="disclaimer-content">
        <h3>Ważne informacje o bezpieczeństwie</h3>
        <p>
          Wprowadzenie zalecanych zmian <strong>znacząco zmniejsza ryzyko</strong> ataków i włamania na Twoją stronę, 
          ale pamiętaj – <strong>nie ma rozwiązania, które gwarantuje 100% bezpieczeństwa</strong>.
        </p>
        <p>
          Bezpieczeństwo strony to <strong>proces ciągły</strong>, który wymaga regularnych audytów, aktualizacji 
          i monitorowania. Ten audyt to pierwszy krok w kierunku lepszej ochrony Twojej witryny.
        </p>
        <p>
          <strong>Pamiętaj:</strong> Hosting często ma swoje własne zabezpieczenia i ograniczenia. Nie wszystkie zalecenia 
          muszą lub mogą być wdrożone – <strong>nie dąż do osiągnięcia 100% wyniku za wszelką cenę</strong>. 
          Czasami dostawca hostingu blokuje pewne zmiany ze względów bezpieczeństwa, co jest normalne.
        </p>
        <div class="disclaimer-tips">
          <h4>Co jeszcze warto zrobić:</h4>
          <ul>
            <li>Regularne kopie zapasowe (zalecane: codziennie)</li>
            <li>Monitoring ruchu i prób włamania</li>
            <li>Dwuskładnikowe uwierzytelnianie (2FA)</li>
            <li>Firewall aplikacyjny (WAF)</li>
            <li>Regularne audyty bezpieczeństwa</li>
          </ul>
        </div>
        <p class="disclaimer-cta-intro">
          <strong>Potrzebujesz pomocy we wdrożeniu zaleceń lub kompleksowym zabezpieczeniu strony?</strong> 
          Jestem dostępny, aby pomóc Ci stworzyć solidną strategię bezpieczeństwa.
        </p>
      </div>
    </div>



    <!-- CTA -->
<div class="wptech-cta">
  <div class="cta-image">
    <img src="<?php echo plugin_dir_url(__DIR__) . 'assets/img/cta.png'; ?>" alt="Pomoc techniczna">
  </div>

  <div class="cta-form">
    <div class="wptech-form-container">
      <h2>Potrzebujesz pomocy?</h2>
      <p>Wyślij zgłoszenie – odpowiem w 24h</p>
      <form method="post">
        <textarea name="wptech_message" placeholder="Krótki opis problemu (opcjonalnie)"></textarea>
        <button type="submit" name="wptech_submit_help" class="wptech-btn-primary">Wyślij zgłoszenie</button>
      </form>
<div class="cta-note">
  Zgłoszenie zostanie przesłane z adresu:
  <span class="wptech-email-wrapper">
    <span class="wptech-email-display">
      <strong><?php echo esc_html(wp_get_current_user()->user_email); ?></strong>
    </span>
    <input type="email" class="wptech-email-input" style="display:none;" placeholder="Wpisz inny adres email">
  </span>
  <button type="button" class="wptech-btn-text wptech-edit-email">
    <i>
      <svg width="14" height="14" fill="currentColor"><path d="M12.3 2.3a1 1 0 0 0-1.4 0L5 8.2V9h.8l5.9-5.9a1 1 0 0 0 0-1.4zM4 9v1h1l6-6-1-1-6 6z"/></svg>
    </i> Zmień
  </button>
</div>
    </div>
    <div class="cta-error" style="display:none;color:#d63638;font-weight:bold;margin-top:10px;"></div>
    <div class="wptech-thankyou" style="display:none;">
      <p>
        Dziękujemy za przesłanie zgłoszenia.<br>
        Odpowiemy na Twój adres <strong></strong> w ciągu najbliższych 24h.
      </p>
      <button class="wptech-thankyou-close wptech-btn-secondary">Zamknij</button>
    </div>
  </div>
</div>
    



<?php endif; ?>
</div>
<?php
}