<?php
/*
Plugin Name: Audyt techniczny
Description: Profesjonalny audyt stanu strony z podziałem na bezpieczeństwo, wydajność, aktualność i diagnostykę.
Version: 1.5.0
Author: Paweł Deluga | Pomoc Techniczna WordPress
Author URI: https://paweldeluga.pl
*/

defined('ABSPATH') or die('No script kiddies please!');

// Klasy i funkcje
require_once plugin_dir_path(__FILE__) . 'includes/class-wptech-audit.php';
require_once plugin_dir_path(__FILE__) . 'includes/admin-page.php';

/**
 * Dodanie strony w menu
 */
add_action('admin_menu', function() {
    add_menu_page(
        'Audyt techniczny',
        'Audyt techniczny',
        'manage_options',
        'wptech-status',
        'wptech_render_admin_page',
        'dashicons-shield-alt',
        80
    );
});

/**
 * AJAX - uruchamianie audytu
 */
add_action('wp_ajax_wptech_run_audit', function() {
    check_ajax_referer('wptech_nonce');

    $results = WPTech_Audit::run_audit();
    update_option('wptech_audit_cached_results', $results);
    update_option('wptech_audit_last_run', current_time('mysql'));

    wp_send_json_success(['message' => 'Audyt wykonany.']);
});

add_action('phpmailer_init', function($phpmailer) {
    // Zapisz w globalnej zmiennej info o tym, czy SMTP jest włączone
    global $wptech_is_smtp;
    $wptech_is_smtp = $phpmailer->Mailer === 'smtp';
});

/**
 * AJAX - zgłoszenie pomocy
 */
add_action('wp_ajax_wptech_submit_help', function() {

    // Sprawdź uprawnienia użytkownika
    if (!current_user_can('manage_options')) {
        wp_send_json_error('Brak uprawnień.');
    }

    // Pobierz użytkownika
    $current_user = wp_get_current_user();
    $default_email = sanitize_email($current_user->user_email);

    // Pobierz e-mail z POST
    if (isset($_POST['email']) && !empty($_POST['email'])) {
        $email = sanitize_email($_POST['email']);
    } else {
        $email = $default_email;
    }

    // Pobierz wiadomość
    $message = isset($_POST['message']) ? sanitize_textarea_field($_POST['message']) : '';

    // Przygotuj dane e-maila - ADRES EMAIL
    $to = 'pawel.deluga@gmail.com';
    $subject = 'Nowe zgłoszenie pomocy WP-TECH';
    $body = "E-mail: " . $email . "\n\nOpis problemu:\n" . $message;
    $headers = array(
        'Content-Type: text/plain; charset=UTF-8',
        'Reply-To: ' . $email
    );

    global $wptech_is_smtp;
    $is_smtp = !empty($wptech_is_smtp) && $wptech_is_smtp === true;

    // Wyślij wiadomość
    $sent = wp_mail($to, $subject, $body, $headers);
    error_log('MAIL SENT RESULT: ' . var_export($sent, true));
    error_log('--- WPTECH DEBUG END ---');

    if ($sent) {
        wp_send_json_success([
            'email' => $email,
            'smtp' => $is_smtp
        ]);
    } else {
        wp_send_json_error('Nie udało się wysłać wiadomości. Upewnij się, że Twój serwer ma skonfigurowane SMTP.');
    }
});

/**
 * Enqueue CSS + JS
 */
add_action('admin_enqueue_scripts', function($hook) {
    if ($hook !== 'toplevel_page_wptech-status') return;

    // CSS
    wp_enqueue_style(
        'wptech-style',
        plugin_dir_url(__FILE__) . 'assets/css/style.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/css/style.css')
    );

    // JS główny
    wp_enqueue_script(
        'wptech-script',
        plugin_dir_url(__FILE__) . 'assets/js/script.js',
        ['jquery'],
        filemtime(plugin_dir_path(__FILE__) . 'assets/js/script.js'),
        true
    );

    // JS UI (np. obsługa tabów, toggle szczegółów)
    wp_enqueue_script(
        'wptech-ui',
        plugin_dir_url(__FILE__) . 'assets/js/audit-ui.js',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/js/audit-ui.js'),
        true
    );

    // Przekazanie danych AJAX
    wp_localize_script('wptech-script', 'wptech_ajax', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce'    => wp_create_nonce('wptech_nonce')
    ]);
});

// Dodaj link do strony audytu w panelu wtyczek
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function($links) {
    $url = admin_url('admin.php?page=wptech-status');
    $custom_link = '<a href="' . esc_url($url) . '" style="font-weight:bold;color:#246bff;">▶ Uruchom Audyt</a>';
    array_unshift($links, $custom_link);
    return $links;
});

/**
 * Hook przy aktywacji wtyczki - wyślij powiadomienie
 */
register_activation_hook(__FILE__, 'wptech_send_activation_notification');

function wptech_send_activation_notification() {
    // Sprawdź czy już wysłano (zabezpieczenie przed duplikatami)
    if (get_option('wptech_activation_sent')) {
        return;
    }

    // Zbierz informacje o instalacji
    $domain = !empty($_SERVER['HTTP_HOST']) ? sanitize_text_field($_SERVER['HTTP_HOST']) : 'nieznana';
    $site_url = get_site_url();
    $wp_version = get_bloginfo('version');
    $php_version = PHP_VERSION;
    $plugin_version = '1.5.0';
    $activation_date = current_time('mysql');
    
    // Przygotuj dane e-maila
    $to = 'pawel.deluga@gmail.com';
    $subject = '[Audyt techniczny] Nowa aktywacja - ' . $domain;
    $body = "Nowa aktywacja wtyczki Audyt techniczny:\n\n";
    $body .= "🌐 Domena: " . $domain . "\n";
    $body .= "🔗 URL: " . $site_url . "\n";
    $body .= "📅 Data aktywacji: " . $activation_date . "\n";
    $body .= "🔧 WordPress: " . $wp_version . "\n";
    $body .= "⚙️ PHP: " . $php_version . "\n";
    $body .= "📦 Wtyczka: v" . $plugin_version . "\n\n";
    $body .= "---\n";
    $body .= "Automatyczne powiadomienie z wtyczki Audyt techniczny";
    
    $headers = array(
        'Content-Type: text/plain; charset=UTF-8',
        'From: Audyt techniczny <noreply@' . $domain . '>'
    );

    // Wyślij e-mail (w tle, bez blokowania aktywacji)
    wp_mail($to, $subject, $body, $headers);
    
    // Oznacz jako wysłane
    update_option('wptech_activation_sent', true);
}